<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 12/02/2016
 * Time: 10:33
 */

namespace Bloom\Honda\Rappel\Model;


use Bloom\Model\Base;

class Campagne extends Base
{
    static protected $table = 'campagne';

    public $code;
    public $modele;
    public $start;
    public $label;
    public $message;
    public $vin;
    public $serie_start;
    public $serie_end;

    public function checkVin($vin) {
        if(strlen($vin) !== 17) {
            throw new \InvalidArgumentException('Vin must be a 17 long character set');
        }

        if(preg_match('~'.str_replace('*','.',$this->vin).'(.{6})~', $vin, $matches)) {
            $a = (int) $matches[1];

            return $a >= $this->serie_start && $a <= $this->serie_end;
        }

        return false;
    }
}