<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 12/02/2016
 * Time: 16:51
 */

namespace Bloom\Honda\Rappel\Model;


use Slim\PDO\Database;

class CampagneTest extends \PHPUnit_Framework_TestCase
{

    public static function setUpBeforeClass()
    {
        Campagne::setDataBase(new Database('mysql:host=192.168.0.53;dbname=d_loic_services-moto','loic','LoicBloom', [ \PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8']));
    }

    public function test_checkVin()
    {
        /**
         * @var Campagne $campagne
         */
        $campagne = Campagne::getItem();

        $vin = 'JH2RC62AGCK000687';
        $vin_2 = 'JH2RC62AGCK021687';

        static::assertTrue($campagne->checkVin($vin));
        static::assertFalse($campagne->checkVin($vin_2));
    }

    /**
     * @expectedException \InvalidArgumentException
     * @expectedExceptionMessage Vin must be a 17 long character set
     */
    public function test_checkVinFailed()
    {
        Campagne::setDataBase(new Database('mysql:host=192.168.0.53;dbname=d_loic_services-moto','loic','LoicBloom', [ \PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8']));

        /**
         * @var Campagne $campagne
         */
        $campagne = Campagne::getItem();

        $vin = 'dfsojbezftpiubihor"éohiré"jknfsdkmlndsùj';

        $campagne->checkVin($vin);
    }
}
