<?php

namespace Bloom\Honda\Entretien\Model;

use Bloom\Model\Base;
/**
 *
 */
class Operation extends Base
{

    static protected $doNotStore = ['entretien'];

    /**
     * @var string
     */
    public $label;

    /**
     * @var string
     */
    public $note;

    /**
     * @var \Bloom\Honda\Entretien\Model\Entretien
     */
    public $entretien;

    /**
     * @param string  $format
     * @return string
     */
    public function format($format)
    {
        return sprintf($format, $this->label, $this->note);
    }
}
