<?php

namespace Bloom\Honda\Entretien\Model;

use Bloom\Model\Base;
use Bloom\Model\Relationship;

/**
 *
 */
class Modele extends Base
{

    /**
     * @var int
     */
    public $id;

    /**
     * @var string
     */
    public $code;

    /**
     * @var string
     */
    public $vin;

    /**
     * @var string
     */
    public $label;
    /**
     * @var string
     */
    public $annee;
    /**
     * @var  float
     */
    public $pression_av;
    /**
     * @var  float
     */
    public $pression_ar;


    public function __construct()
    {
        static::$relationship[] = (new Relationship('pieces', Piece::class))
            ->setEndProperty('modele')
            ->OneToMany()
            ->setNavigable()
            ->correspondenceTable('pieces_modeles', 'modeles_id', 'pieces_id');
        static::$relationship[] = (new Relationship('entretiens', Entretien::class))
            ->setEndProperty('modele')
            ->OneToMany()
            ->setNavigable()
            ->correspondenceTable('entretiens_modeles', 'modeles_id', 'entretiens_id');
        static::$relationship[] = (new Relationship('pneus', Pneu::class))
            ->setEndProperty('modele')
            ->OneToMany()
            ->setNavigable()
            ->correspondenceTable('pneus_modeles', 'modeles_id', 'pneus_id');
    }

    protected function cleanBuild($item = null)
    {
        parent::cleanBuild($item);
        usort($this->entretiens, function(Entretien $a,Entretien $b) {
            if ($a->km === $b->km) {
                return 0;
            }
            return ((int) $a->km < (int) $b->km) ? -1 : 1;
        });
        usort($this->pieces, function(Piece $a,Piece $b) {
            if ($a->label === $b->label) {
                return 0;
            }
            return ($a->label < $b->label) ? -1 : 1;
        });
        usort($this->pneus, function(Pneu $a,Pneu $b) {
            if ($a->label === $b->label) {
                return 0;
            }
            return ($a->label < $b->label) ? -1 : 1;
        });
    }


    /**
     * @param null $annees
     * @return string
     */
    public function formatAnnee($annees = null)
    {
        if($annees === null) {
            $annees= $this->annee;
        }
        if(strlen($annees) === 1) {
            $a = static::$db->query('SELECT * FROM annee_modele WHERE letter = "'.$annees.'"')->fetchAll();
            return $a[count($a) -1]['annee'];
        }

        $str = [];
        foreach (explode('~', $annees) as $annee) {
            $a = static::$db->query('SELECT * FROM annee_modele WHERE letter = "'.$annee.'"')->fetchAll();
            $str[] = $a[count($a) -1]['annee'];
        }
        return implode('~', $str);
    }
}
