<?php

namespace Bloom\Honda\Entretien\Model;

use Bloom\Model\Base;
use Bloom\Model\Relationship;

/**
 *
 */
class Entretien extends Base
{
    static protected $doNotStore = ['modele'];
    /**
     * @var int
     */
    public $id;

    /**
     * @var int
     */
    public $mois;

    /**
     * @var int
     */
    public $km;

    /**
     * @var float
     */
    public $duree ;

    /**
     * @var \Bloom\Honda\Entretien\Model\Modele
     */
    public $modele;

    public function __construct()
    {
    }

    protected function cleanBuild($item = null)
    {
        parent::cleanBuild($item);
        $this->operations = [];
        foreach(static::$db->select()->from('operation_entretiens')->where('entretiens_id','=',$this->id)->where('modeles_id','=',$this->modele->id)->execute()->fetchAll() as $a){
            $a = Operation::getItem([['column'=>'id','value'=>$a['operations_id'],'operator'=>'=']]);
            $a->entretien = $this;
            $this->operations[] = $a;
        }
    }


    /**
     * Return a string like :
     * hour H minutes
     * @return string
     */
    public function dureeFormat()
    {
        $hours = floor($this->duree/60);
        $minutes = $this->duree % 60;
        return sprintf('%dH %dmin', $hours, $minutes);
    }

    /**
     * Return a string like
     * 6 000 KM
     * 186 000 KM
     * @return string
     */
    public function kmFormat()
    {
        return sprintf('%s KM', number_format($this->km, 0, '.', ' '));
    }
}
