<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 03/02/2016
 * Time: 11:45
 */

namespace Bloom\Honda\Entretien\Command;


use Bloom\Honda\Entretien\Model\Entretien;
use Bloom\Honda\Entretien\Model\Modele;
use Bloom\Honda\Entretien\Model\Operation;
use Bloom\Honda\Entretien\Model\Piece;
use Bloom\Honda\Entretien\Model\Pneu;
use Bloom\Model\Base;
use Bloom\System\Memory;
use FilesystemIterator;
use PDO;
use Slim\PDO\Database;
use SplFileInfo;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Exception\InvalidOptionException;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Bloom\System\Csv;
use Symfony\Component\Console\Question\ConfirmationQuestion;

class Import extends Command
{
    /**
     * @todo Change this to an actual ftp directory
     */
    const DEFAULT_LOAD_DIR = '/someDirectory';
    const FILE_CHARSET = 'ISO-8859-1';
    /**
     * @var \Slim\PDO\Database
     */
    static protected $db;

    /**
     * @var InputInterface
     */
    protected $input;
    /**
     * @var OutputInterface
     */
    protected $output;

    /**
     * @var SplFileInfo[]
     */
    protected $splFiles;

    protected function configure()
    {
        $this->setName('hmk:import')
            ->setDescription('Import data in database')
            ->setDefinition([
                new InputOption('directory', 'd', InputOption::VALUE_REQUIRED, 'Set the source directory to find the *.csv files'),
                new InputOption('file', 'f', InputOption::VALUE_REQUIRED, 'Set the file to import from, <info>--table must be specified</info>'),
                new InputOption('table', 't', InputOption::VALUE_REQUIRED, 'Set the table to import in'),
                new InputOption('database', null, InputOption::VALUE_REQUIRED, 'Set the database to import in', 'd_loic_services-moto')
            ]);
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws InvalidOptionException
     * @return bool
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        static::$db = new Database('mysql:host=bertaga.bloom;dbname='.$input->getOption('database'),'loic','LoicBloom', [ \PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8']);
        static::$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_SILENT);
        Base::setDataBase(static::$db);
        static::$db->exec('
SET foreign_key_checks = 0;
TRUNCATE modeles;
TRUNCATE entretiens;
TRUNCATE operations;
TRUNCATE pneus;
TRUNCATE pieces;
TRUNCATE pieces_modeles;
TRUNCATE pneus_modeles;
TRUNCATE operation_entretiens;
TRUNCATE entretiens_modeles;
SET foreign_key_checks = 1;
');
        $this->input = $input;
        $this->output = $output;
        if ($input->getOption('directory') !== null) {
            $directory = $input->getOption('directory');
            if(preg_match('~^/~',$directory)) {
                return $this->loadDir($directory);
            } else {
                return $this->loadDir(getcwd() . '/' . $directory);
            }
        }
        if ($input->getOption('file') !== null) {
            if ($input->getOption('table') === null) {
                throw new InvalidOptionException('Option file must be paired with --table option');
            }
            if (!in_array($input->getOption('table'), $this->getKnownTable(), true)) {
                $this->errorMessage('Unknown table ' . $input->getOption('table'));
                return false;
            }
//            return $this->load(new SplFileInfo(getcwd() . '/' . $input->getOption('file')), $input->getOption('table'), 1);
        }
        return $this->loadDir(static::DEFAULT_LOAD_DIR);
    }

    /**
     * @param $dir
     * @return bool
     */
    protected function loadDir($dir)
    {
        $startTime = time();
        if ($this->output->isVerbose()) {
            $this->message('Search for file');
        }
        if ($this->output->isDebug()) {
            $this->message('Known table : ' . implode(',', $this->getKnownTable()), 2);
        }
        $indent = 2;
        $files = [
            'MODELES', // Modele
            'MLKM_NivoEntretiens', // Entretiens
            'OPERATIONS', // Operations
            'PIECES', // Pieces && Pneu
            'MDL_PIECES', // Modele -> Pieces && Modele -> Pneus,
            'OP_KMRS_1et2' // Operation -> entretiens | Operations -> modeles
        ];
        $this->splFiles = [];
        foreach ($files as $file) {
            $info = null;
            foreach (new FilesystemIterator($dir, FilesystemIterator::CURRENT_AS_FILEINFO) as $f) {
                /**
                 * @var SplFileInfo $f
                 */
                preg_match('/^MAJ_Web_v\d+_(?<File>\w+).csv/', $f->getFilename(), $matches);
                if ($matches['File'] === $file) {
                    $info = $f;
                }
            }
            if($info !== null) {
                $this->splFiles[$file] = $info;
            }
            if ($info !== null && $this->output->isVerbose()) {
                $this->successMessage('Correspondence ' . $info->getBasename(), $indent -1);
            }
        }

        if (count($this->splFiles) !== count($files)) {
            $this->errorMessage('No valid files found');
            return false;
        }
        $this->message('PRELOADING FILES OP_KMRS1et2 AND MLKM_NivoEntretiens');
        $csv_bis = new Csv($this->splFiles['OP_KMRS_1et2'], 'r');
        $csv_bis->next();
        static::$db->exec('CREATE TEMPORARY TABLE OP_KMRS(
	`OP_ML_ID` VARCHAR(255),
	`OP_KM_ID`VARCHAR(255),
	`OP_TypeOp`VARCHAR(255),
	`OP_LibOp`VARCHAR(255),
	`OP_Regroup`VARCHAR(255),
	`OP_NotePieceInd`VARCHAR(255),
	`OP_PI_Obligatoire`VARCHAR(255), `OP_TempsB`VARCHAR(255)
);');
        $x = 0;
        $statement = static::$db->prepare('INSERT INTO OP_KMRS (OP_ML_ID, OP_KM_ID,OP_TypeOp,OP_LibOp,OP_Regroup,OP_NotePieceInd,OP_PI_Obligatoire,OP_TempsB) VALUES (?,?,?,?,?,?,?,?)');
        while($row = $csv_bis->current()) {
            $statement->execute(array_values($row));
            $x++;
            $csv_bis->next();
        }
        $this->successMessage("{$x} row loaded for OP_KMRS1et2", 2);
        $csv_bis = new Csv($this->splFiles['MLKM_NivoEntretiens'], 'r');
        $csv_bis->next();
        static::$db->exec('CREATE TEMPORARY TABLE MLKM_NivoEntretiens(
	`MLKM_ID` VARCHAR(255),
	`MLKM_IDRef`VARCHAR(255),
	`MLKM_MDL_ID`VARCHAR(255),
	`MLKM_TO_ID`VARCHAR(255),
	`MLKM_ValKM`VARCHAR(255),
	`MLKM_Duree`VARCHAR(255),
	`MLKM_TempsB`VARCHAR(255)
);');
        $x = 0;
        $statement = static::$db->prepare('INSERT INTO MLKM_NivoEntretiens (MLKM_ID, MLKM_IDRef,MLKM_MDL_ID,MLKM_TO_ID,MLKM_ValKM,MLKM_Duree,MLKM_TempsB) VALUES (?,?,?,?,?,?,?)');
        while($row = $csv_bis->current()) {
            $statement->execute(array_values($row));
            $x++;
            $csv_bis->next();
        }
        $this->successMessage("{$x} row loaded for MLKM_NivoEntretiens",2);
        $file = $this->splFiles['MODELES'];
        $this->startLoad($file, Modele::getTable(), $indent -1);
        $csv = new Csv($file->getRealPath(), 'r');
        $csv->next();
        $correspondence = $this->modeleCorrespondance();
        $count = 0;
        while($row = $csv->current()) {
            $modele = new Modele(); // Save on object destruct
            foreach ($correspondence as $item => $core) {
                $modele->{$item} = $core($row);
            }
            if($this->output->isDebug()) {
                $this->output->write(print_r($modele,true));
            }
            $count++;
            $csv->next();
        }
        $this->successMessage($count. ' modeles found', $indent +1);
        $this->endLoad($file, Modele::getTable(), $indent -1);
        $this->startLoad($this->splFiles['PIECES'], Piece::getTable(), $indent-1);
        $csv = new Csv($this->splFiles['PIECES']->getRealPath(),'r');
        $csv->next();
        $correspondence = $this->piecesCorrespondance();
        $known = [];
        while($row = $csv->current()) {
            if(preg_match('/pneu/i',$row['PC_Nom'])) {
                $csv->next();
                continue;
            }
            $ok = false;
            $a = [];
            foreach($correspondence as $item => $core)
            {
                $a[$item] = $core($row);
            }
            foreach($known as $b) {
                foreach ($a as $item => $core) {
                    if($item !== 'ref' && $item !== 'id' && $core !== $b->{$item}) {
                        $ok = true;
                    }
                }
            }
            if(count($known) === 0 ) {
                $ok = true;
            }
            if($ok) {
                $modele = new Piece();
                foreach ($correspondence as $item => $core) {
                    $modele->{$item} = $core($row);
                }
                if($this->output->isDebug()) {
                    $this->output->write(print_r($modele,true));
                }
                $known[] = $modele;
                if($this->output->isDebug()) {
                    $this->output->writeln(print_r($modele,true));
                }
                $modele->save();
            }
            $csv->next();
        }
        $this->successMessage(count($known). ' pieces found', $indent +1);
        $this->endLoad($this->splFiles['PIECES'], Piece::getTable(), $indent-1);
        $this->startLoad($this->splFiles['PIECES'], Pneu::getTable(), $indent-1);
        $csv = new Csv($this->splFiles['PIECES']->getRealPath(),'r');
        $csv->next();
        $correspondence = $this->pneusCorrespondance();
        $known = [];
        while($row = $csv->current()) {
            if(!preg_match('/pneu/i',$row['PC_Nom'])) {
                $csv->next();
                continue;
            }
            $ok = false;
            $a = [];
            foreach($correspondence as $item => $core)
            {
                $a[$item] = $core($row);
            }
            foreach($known as $b) {
                foreach ($a as $item => $core) {
                    if($core !== $b->{$item}) {
                        $ok = true;
                    }
                }
            }
            if(count($known) === 0 ) {
                $ok = true;
            }
            if($ok) {
                $modele = new Pneu();
                foreach ($correspondence as $item => $core) {
                    $modele->{$item} = $core($row);
                }
                if($this->output->isDebug()) {
                    $this->output->write(print_r($modele,true));
                }
                $known[] = $modele;
                $modele->save();
            }
            $csv->next();
        }
        $this->successMessage(count($known). ' pneus found', $indent +1);
        $this->endLoad($this->splFiles['PIECES'], Pneu::getTable(), $indent-1);
        $this->startLoad($this->splFiles['MLKM_NivoEntretiens'], Entretien::getTable(), $indent-1);
        static::$db->query('INSERT INTO entretiens (km, mois, duree) SELECT MLKM_ValKM as km,MLKM_Duree as mois, (MLKM_TempsB/100)*60 as duree FROM MLKM_NivoEntretiens GROUP BY km, duree, mois');
        $this->successMessage(static::$db->select(['count(*)'])->from('entretiens')->execute()->fetchColumn(). ' entretiens found', $indent +1);
        $this->endLoad($this->splFiles['MLKM_NivoEntretiens'], Entretien::getTable(), $indent-1);
        $this->startLoad($this->splFiles['OP_KMRS_1et2'], Operation::getTable(), $indent -1);

        static::$db->query('INSERT INTO operations (label, note) SELECT OP_LibOp as label, OP_NotePieceInd as note FROM OP_KMRS GROUP BY label, note;');

        $this->successMessage(static::$db->select(['count(*)'])->from('operations')->execute()->fetchColumn(). ' operations found', $indent +1);
        $this->endLoad($file, Operation::getTable(), $indent -1);
        $this->message('Search for Modeles - Entretien correspondence', $indent -1);
        $count = 0;
        foreach (static::$db
                     ->select(['*','MLKM_ValKM as km,MLKM_Duree as mois, (MLKM_TempsB/100)*60 as duree'])
                     ->from('MLKM_NivoEntretiens')->execute()->fetchAll() as $row) {
            if($this->output->isDebug()) {
                $this->output->writeln(print_r($row,true));
            }
            $entretien = static::$db->select(['id'])->from('entretiens')
                ->where('km', '=',$row['km'])->where('mois','=',$row['mois'])->where('duree','=',$row['duree'])->execute()->fetchColumn();
            if($this->output->isDebug()) {
                $this->output->writeln(print_r($entretien,true));
            }
            if(!$entretien) {
                continue;
            }
            try {
                static::$db->insert(['modeles_id','entretiens_id'])->into('entretiens_modeles')->values([$row['MLKM_MDL_ID'],$entretien])->execute();
                $count++;
            } catch(\Exception $e) {
                $_SESSION['error'][] = $e;
            }
        }
        $this->successMessage($count.' correspondences founds', $indent +1);
        $this->message('Search for Entretien - Operation correspondence', $indent -1);
        foreach (static::$db->select()->from('modeles')->execute()->fetchAll() as $modele) {
            foreach (static::$db->select(['*', 'MLKM_ValKM as km,MLKM_Duree as mois, (MLKM_TempsB/100)*60 as duree'])->from('MLKM_NivoEntretiens')->where('MLKM_MDL_ID', '=', $modele['id'])->execute()->fetchAll() as $entretien_raw) {
                if($this->output->isDebug()) {
                    $this->output->writeln(print_r($entretien_raw,true));
                    $this->output->writeln(print_r($row,true));
                }
                $entretien = static::$db->select(['id'])->from('entretiens')
                    ->where('km', '=',$entretien_raw['km'])->where('mois','=',$entretien_raw['mois'])->where('duree','=',$entretien_raw['duree'])->execute()->fetchColumn();
                foreach (static::$db->query('SELECT * FROM OP_KMRS WHERE OP_KM_ID = '.$entretien_raw['MLKM_IDRef'].' AND OP_ML_ID = '.$modele['id'])->fetchAll() as $operation) {
                    if($this->output->isDebug()) {
                        $this->output->writeln(print_r($operation,true));
                    }
                    $op = static::$db->select(['id'])->from('operations')->where('label','=',$operation['OP_LibOp'])
                        ->where('note','=',$operation['OP_NotePieceInd'])->execute()->fetchColumn();
                    if($this->output->isDebug()) {
                        $this->output->writeln(print_r($op,true));
                        $this->output->writeln(print_r($entretien,true));
                    }
                    try{
                        static::$db->insert()->into('operation_entretiens')->columns(['modeles_id','entretiens_id', 'operations_id'])->values([$modele['id'],$entretien,$op])->execute(false);
                        $count++;
                    }catch(\Exception $e) {
                        $_SESSION['error'][] = $e;
                    }
                }
            }
        }
        $this->successMessage($count. ' correspondence found', $indent +1);
        $this->message('Search for Pieces/Pneus - Modeles correspondence', $indent -1);
        $count = 0;
        $csv = new Csv($this->splFiles['MDL_PIECES']->getRealPath(),'r');
        $csv->next();
        while($row = $csv->current()) {
            try{
                $table = 'pieces_modeles';
                $columns = ['modeles_id', 'pieces_id'];
                if(Pneu::getItem([['operator'=>'=','column'=>'id','value'=>$row['MDLP_PIE_ID']]])) {
                    $table = 'pneus_modeles';
                    $columns[1] = 'pneus_id';
                }
                if($this->output->isDebug()) {
                    $this->output->writeln(print_r($row,true));
                }
                static::$db->insert()->into($table)->columns($columns)->values([$row['MDLP_MDL_ID'],$row['MDLP_PIE_ID']])->execute(false);
                $count++;
            }catch(\Exception $e) {
                $_SESSION['error'][] = $e;
            }
            $csv->next();
        }
        $this->successMessage($count. ' correspondence found', $indent +1);
        if($_SESSION !== null && array_key_exists('error', $_SESSION) && ($e=count($_SESSION['error'])) > 0)
        {
            $this->errorMessage('Sauvegarde effectuer avec '.$e.' erreur(s)');
            if($this->getHelper('question')->ask($this->input,$this->output, new ConfirmationQuestion('Afficher la listes des erreurs ? [<info>Y</info>n]'))) {
                foreach ($_SESSION['error'] as $error) {
                    /**
                     * @var \Exception $error
                     */
                    $this->output->writeln($error->getMessage());
                    $this->output->writeln($error->getTraceAsString());
                }
            }
        }
        $this->message('Executed in '.((time() - $startTime)/60).' minute(s)', $indent -1);
        return true;
    }

    protected function startLoad(SplFileInfo $file, $table, $indent = 0)
    {
        if ($this->output->isVeryVerbose()) {
            $this->message('Start Import ' . $file->getBasename() . ' into ' . $table, $indent);
        } else  if ($this->output->isDebug()) {
            $this->message('Start Import ' . $file->getRealPath() . ' into ' . $table, $indent);
        }
    }

    protected function endLoad(SplFileInfo $file, $table, $indent)
    {
        if ($this->output->isVerbose()) {
            $this->successMessage($file->getBasename() . ' imported into ' . $table, $indent);
        } else  if ($this->output->isDebug()) {
            $this->successMessage($file->getRealPath() . ' imported into ' . $table, $indent);
        }
    }

    protected function message($message, $indent = 1)
    {
        $this->output->writeln(str_repeat(' ', $indent) . '<fg=cyan>➢</> ' . $message);
    }

    protected function successMessage($message, $indent = 1)
    {
        $this->output->writeln(str_repeat(' ', $indent) . '<info>✓</info>  ' . $message);
    }

    protected function errorMessage($message, $indent = 1)
    {
        $this->output->writeln(str_repeat(' ', $indent) . '<fg=red>✘</>  ' . $message);
    }

    private function getKnownTable()
    {
        return [Entretien::getTable(), Modele::getTable(), Operation::getTable(), Piece::getTable(), Pneu::getTable()];
    }

    protected function piecesCorrespondance()
    {
        return [
            'id' => function ($row) {
                return (int)$row['PC_ID'];
            },
            'ref' => function ($row) {
                return $row['PC_Ref'];
            },
            'label' => function ($row) {
                return $row['PC_Nom'];
            },
            'marque' => function ($row) {
                return $row['PC_Marque'];
            },
            'type' => function ($row) {
                return $row['PC_Type'];
            },
            'prix' => function ($row) {
                return ((float)$row['PC_Prix'] ) / 100;
            }
        ];
    }

    protected function pneusCorrespondance()
    {
        return [
            'id' => function ($row) {
                return (int)$row['PC_ID'];
            },
            'ref' => function ($row) {
                return $row['PC_Ref'];
            },
            'label' => function ($row) {
                return $row['PC_Nom'];
            },
            'marque' => function ($row) {
                return $row['PC_Marque'];
            },
            'type' => function ($row) {
                return $row['PC_Type'];
            },
            'dimension' => function ($row) {
                return $row['PC_Dim'];
            }
        ];
    }

    protected function modeleCorrespondance()
    {
        return [
            'id' => function ($row) {
                return (int)$row['ML_ID'];
            },
            'code' => function ($row) {
                return $row['ML_Code'];
            },
            'vin' => function ($row) {
                return $row['ML_VIN'];
            },
            'annee' => function ($row) {
                return $row['ML_Annee'];
            },
            'label' => function ($row) {
                return $row['ML_Libelle'];
            },
            'pression_av' => function ($row) {
                return ((float)$row['ML_PneuAV'])/100;
            },
            'pression_ar' => function ($row) {
                return ((float)$row['ML_PneuAR'])/100;
            }
        ];
    }

    protected function entretienCorrespondance()
    {
        return [
            'mois' => function ($row) {
                return (int)$row['MLKM_Duree'];
            },
            'km' => function ($row) {
                return (int)$row['MLKM_ValKM'];
            },
            'duree' => function ($row) {
                return ( ((float)$row['MLKM_TempsB'] )/100) * 60;
            }
        ];
    }

    protected function operationsCorrespondance()
    {
        return [
            'id'=>function($row) {
                return (int) $row['OP_ID'];
            },
            'label' => function ($row) {
                return $row['OP_Libelle'];
            },
            'note' => function ($row) {
                return $row['OP_Note'];
            }
        ];
    }
}