<?php

namespace Tests\MagnewsAdaptaterTest;

use MagnewsAdaptater\Error\MagnewsException;
use MagnewsAdaptater\MagnewsAdaptater;
use MagnewsAdaptater\MagnewsDAO\MagnewsSoap;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use PHPUnit\Framework\Assert;
use PHPUnit\Framework\TestCase;
use SoapFault;

class MagnewsAdaptaterTest extends TestCase
{

    public function tearDown(): void
    {
        MagnewsAdaptater::tearDown();
    }

    public function getInstance(): MagnewsAdaptater
    {
        $logger = new Logger('test-magnews', [new StreamHandler('.')]);
        return MagnewsAdaptater::getInstance($logger, APP_PATH);
    }

    public function testGetInstance()
    {
        $instance = $this->getInstance();
        $instance_2 = MagnewsAdaptater::getInstance();
        Assert::assertEquals($instance, $instance_2);

        $this->tearDown();
    }

    public function testSendTransactionalMail()
    {

    }

    public function testGetLogger()
    {
        $logger = new Logger('test-magnews', [new StreamHandler('.')]);
        $instance = MagnewsAdaptater::getInstance($logger, APP_PATH);
        Assert::assertEquals($logger, $instance->getLogger());

        $this->tearDown();
    }

    /**
     * @throws MagnewsException
     * @throws SoapFault
     */
    public function testGetSoapClient()
    {
        $instance = $this->getInstance();
        $url = 'https://someshit.com';
        $soapClient = new MagnewsSoap($url);
        $soapClientThroughtSingleton = $instance->getSoapClient($url);
        Assert::assertEquals($soapClient, $soapClientThroughtSingleton);

    }
}
