<?php

namespace MagnewsAdaptater\Mailer;

use Exception;
use MagnewsAdaptater\Error\MagnewsException;
use MagnewsAdaptater\MagnewsAdaptater;
use MagnewsAdaptater\MagnewsDAO\EmailMessage;
use MagnewsAdaptater\MagnewsDAO\TypedValue;
use SoapFault;

class MagnewsMailer
{

    /**
     * @throws MagnewsException
     * @throws Exception
     */
    public static function sendTransactionalMailMagnews(
        $credentials,
        $fromEmail,
        $fromName,
        $replyTo,
        $to,
        $subject,
        $idTemplate,
        $typedValues = [],
        $idMessage = ''
    ): bool
    {

        $wsdl_url = 'https://ws-mn1.mag-news.it/ws/wsapi?wsdl';
        $emailMessage = new EmailMessage($fromEmail, $fromName, $to, $replyTo, $subject);
        $emailMessage->idmessagetype = $idMessage;

        $option = [
            ['key' => 'messageRetention', 'value' => 'full'],
            ['key' => 'usenewsletterastemplate', 'value' => 'true'],
            ['key' => 'renderatsend', 'value' => 'false'],
            ['key' => 'idnewsletter', 'value' => $idTemplate],
            ['key' => 'usehtmlcodeastemplate', 'value' => 'true'],
            ['key' => 'nospool', 'value' => 'true'],
        ];

        if (count($typedValues) !== 0) {
            $emailMessage->tempvar = $typedValues;
        }

        try {
            $client = MagnewsAdaptater::getInstance()->getSoapClient($wsdl_url);
            $params = [
                'message' => $emailMessage,
                'option' => $option,
                'credentials' => $credentials,
            ];

            return $client->sendEmailMessage($params);

        } catch (SoapFault $e) {
            throw new MagnewsException(
                'Erreur SOAP (réponse indisponible)',
                $e->getMessage(),
                $e->getCode(),
                $e
            );
        } catch (Exception $e) {
            throw new Exception(
                self::class . ' : Erreur inconnue à l\'envoi',
                $e->getCode(),
                $e
            );
        }
    }

    public static function createTypedValue($name, $value, $valueType): TypedValue
    {
        return new TypedValue($name, $value, $valueType);
    }
}