<?php

namespace MagnewsAdaptater\MagnewsDAO;

use MagnewsAdaptater\Error\MagnewsException;
use MagnewsAdaptater\MagnewsAdaptater;
use Monolog\Logger;
use SoapClient;
use SoapFault;

/**
 * @method sendEmailMessage(array $params)
 */
class MagnewsSoap extends SoapClient
{
    private Logger $logger;
    private $credentials;

    /**
     * @throws SoapFault
     * @throws MagnewsException
     */
    public function __construct(?string $wsdl, array $options = null)
    {
        $magnewsAdaptater = MagnewsAdaptater::getInstance();
        $this->logger = $magnewsAdaptater->getLogger();
        $this->credentials = $magnewsAdaptater->getCredentials();
        parent::__construct($wsdl, $options);
    }

    /**
     * @inheritDoc
     */
    public function __call(string $name, array $args): mixed
    {
        if (!array_key_exists('credentials', $args[0])) {
            $args[0]['credentials'] = $this->credentials->toArray();
            $this->logger->debug('force credentials', ['credentials' => $args[0]['credentials'], 'args' => $args[0]]);
        }
        return parent::__soapCall($name, $args);
    }
}