<?php

namespace MagnewsAdaptater\Error;

use Exception;

class MagnewsException extends \Exception
{
    private string $raw_body;

    public function getRawBody()
    {
        return $this->raw_body;
    }

    /**
     * @param string $raw_body
     * @param string $message
     * @param int|string $code
     * @param Exception|null $previous
     */
    public function __construct(string $raw_body, $message = "", $code = 0, Exception $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->raw_body = $raw_body;
    }
}