<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 16/03/2017
 * Time: 14:16
 */
namespace Bloom\LaravelSendinblue;

use Illuminate\Support\ServiceProvider;
use SendinBlue\Client\Configuration;

class SendinBlueServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->app['swift.transport']->extend('sendinblue', function ($app) {
            return new SendinBlueTransport(
                Configuration::getDefaultConfiguration()
                    ->setApiKey(
                        'api-key',
                        $app['config']['services.sendinblue.key']
                    ),
                $app['config']['services.sendinblue.tag']
            );
        });
    }
    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function register()
    {

        $this->app->singleton('sms', function($app) {
            return new SendinblueSmsTransport(
                Configuration::getDefaultConfiguration()
                    ->setApiKey(
                        'api-key',
                        $app['config']['services.sendinblue.key']
                    ),
                $app['config']['services.sendinblue.tag']
            );
        });
    }
}
