<?php

namespace Bloom\LaravelSendinblue\Facades;

use Bloom\LaravelSendinblue\Message;
use Bloom\LaravelSendinblue\SendinBlueTransport;
use Exception;
use SendinBlue\Client\Configuration;

class SendinblueMailTransport
{
    protected $transport;

    protected $key;
    protected $tag;

    public function __construct(string $key, string $tag)
    {
        $this->key = $key;
        $this->tag = $tag;

        $this->transport = new SendinBlueTransport(
            Configuration::getDefaultConfiguration()
                ->setApiKey('api-key', $this->key), $this->tag);
    }

    public function send(Message $config): bool
    {
        $message = new \Swift_Message($config->subject);
        $message
            ->setFrom($config->from)
            ->setTo($config->to)
            ->setBody($config->body, $config->contentType, $config->charset)
            ->addPart(strip_tags($config->body));

        if ($config->pj !== null) {
            $message->attach($config->pj);
        }

        if ($config->replyTo !== null) {
            $message->setReplyTo($config->replyTo);
        }

        try {
            $this->transport->send($message);
            return true;
        } catch (Exception $e) {
            return false;
        }
    }
}