<?php

namespace Bloom\LaravelSendinblue;

class Message {
    public $subject;
    public $body;
    public $to;
    public $from;
    public $pj;
    public $charset;
    public $contentType;
    public $replyTo;

    public function __construct($subject = null, $body = null, $to = null, $from = null)
    {
        $this->subject = $subject;
        $this->body = $body;
        $this->to = $to;
        $this->from = $from;
        $this->charset = 'utf-8';
        $this->contentType = 'text/html';
    }

    public function setSubject($subject)
    {
        $this->subject = $subject;
        return $this;
    }

    public function setBody($body, $contentType, $charset)
    {
        $this->body = $body;
        $this->contentType = $contentType;
        $this->charset = $charset;
        return $this;
    }

    public function setTo(array $to)
    {
        $this->to = $to;
        return $this;
    }

    public function setFrom(array $from)
    {
        $this->from = $from;
        return $this;
    }

    public function setPj(array $pj)
    {
        $this->pj = $pj;
        return $this;
    }

    public function setReplyTo(array $replyTo)
    {
        $this->replyTo = $replyTo;
        return $this;
    }

    public function addPart(array $body)
    {
        $this->body = $body;
        return $this;
    }
}