<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 16/03/2017
 * Time: 14:16
 */
namespace Bloom\LaravelSendinblue;

use Illuminate\Mail\MailManager;
use Illuminate\Support\ServiceProvider;
use SendinBlue\Client\Configuration;


class SendinBlueServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->app[MailManager::class]->extend('sendinblue', function () {
            return new SendinBlueTransport(
                Configuration::getDefaultConfiguration()
                    ->setApiKey(
                        'api-key',
                        $this->app['config']['services.sendinblue.key']
                    ),
                $this->app['config']['services.sendinblue.tag']
            );
        });
    }
    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function register()
    {

        $this->app->singleton('sms', function($app) {
            return new SendinblueSmsTransport(
                Configuration::getDefaultConfiguration()
                    ->setApiKey(
                        'api-key',
                        $app['config']['services.sendinblue.key']
                    ),
                $app['config']['services.sendinblue.tag']
            );
        });
    }
}
