<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 05/07/18
 * Time: 12:09
 */

namespace Bloom\LaravelSendinblue;


use Illuminate\Support\Facades\Log;
use libphonenumber\PhoneNumberFormat;
use Sendinblue\Mailin;

class SendinblueSmsTransport
{
    /**
     * The SendinBlue instance.
     *
     * @var \Sendinblue\Mailin
     */
    protected $mailin;
    /**
     * @var string
     */
    protected $tag;

    /**
     * Create a new SendinBlue transport instance.
     *
     * @param  \Sendinblue\Mailin $mailin
     * @param string              $tag Tag for sendinblue api
     *
     * @return void
     */
    public function __construct(Mailin $mailin, $tag)
    {
        $this->mailin = $mailin;
        $this->tag = $tag;
    }

    private function parse_result($result)
    {
        if ($result["code"] == "success") {
            return true;
        }
        Log::error('Error while sending mail', ['response' => $result]);
        return false;
    }

    public function send($to, $text, $from)
    {
        $phoneUtil = \libphonenumber\PhoneNumberUtil::getInstance();
        if(!$phoneUtil->isValidNumber($to)) {
            Log::debug("Invalid phone number given", ['text' => $text]);
            return false;
        }
        Log::debug("Sending SMS", ['text' => $text]);
        return $this->parse_result($this->mailin->send_sms([
            'to'   => $phoneUtil->format($to, PhoneNumberFormat::INTERNATIONAL),
            'text' => $text,
            'from' => $from,
            'tag'  => $this->tag,
            'type' => 'transactional'
        ]));
    }
}