<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 16/03/2017
 * Time: 14:16
 */
namespace Bloom\LaravelSendinblue;

use Illuminate\Support\ServiceProvider;
use Sendinblue\Mailin;

class SendinBlueServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->app['swift.transport']->extend('sendinblue', function ($app) {
            return new SendinBlueTransport(
                $app[Mailin::class],
                $app['config']['services.sendinblue.tag']
            );
        });
    }
    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(Mailin::class, function ($app) {
            return new Mailin($app['config']['services.sendinblue.url'], $app['config']['services.sendinblue.key']);
        });

        $this->app->singleton('sms', function($app) {
            return new SendinblueSmsTransport($app[Mailin::class], $app['config']['services.sendinblue.tag']);
        });
    }
}
