<?php
/**
 * Created by IntelliJ IDEA.
 * User: Michel
 * Date: 04/04/2017
 * Time: 15:59
 */

namespace Bloom\Reminder\Services;


use Bloom\Reminder\Error\VehiculeNotFound;
use GuzzleHttp\Client;

/**
 * Class ReminderApi
 * @package Bloom\Reminder\Services
 */
class ReminderApi
{
    protected $client;
    protected $config;
    protected $division = 'auto';

    /**
     * ReminderApi constructor.
     *
     * @param array $config
     */
    public function __construct($config = [])
    {
        $this->client = new Client();
        $this->config = $config;
    }

    /**
     * @param string $immat Immatriculation a rechercher
     *
     * @return mixed
     * @throws VehiculeNotFound
     */
    public function searchImmat($immat)
    {
        $url = $this->config['base_url'] . '/administration/api/vehicules/immat/' . $immat;
        $url = str_replace('auto', $url, $this->division);
        $res = $this->client->request('GET', $url);
        $json = $res->getBody()->getContents();
        $data = \json_decode($json, true);
        if ($data['status']) {
            return $data['data'];
        }

        throw new VehiculeNotFound();
    }

    /**
     * @param string $vin
     *
     * @return mixed
     * @throws VehiculeNotFound
     */
    public function searchVin($vin)
    {
        $url = $this->config['base_url'] . '/administration/api/vehicules/vin/' . $vin;
        $url = str_replace('auto', $url, $this->division);
        $res = $this->client->request('GET', $url);
        $json = $res->getBody()->getContents();
        $data = \json_decode($json, true);
        if ($data['status']) {
            return $data['data'];
        }

        throw new VehiculeNotFound();
    }

    public function vehiculeNomenclature()
    {
        $url = $this->config['base_url'] . '/administration/api/vehicules/nomenclature';
        $url = str_replace('auto', $url, $this->division);
        $res = $this->client->request('GET', $url);
        $json = $res->getBody()->getContents();
        $data = \json_decode($json, true);
        if ($data['status']) {
            return $data['data'];
        }

        throw new \HttpException();
    }

    public function civiliteNomenclature()
    {
        $url = $this->config['base_url'] . '/administration/api/civilite/nomenclature';
        $url = str_replace('auto', $url, $this->division);
        $res = $this->client->request('GET', $url);
        $json = $res->getBody()->getContents();
        $data = \json_decode($json, true);
        if ($data['status']) {
            return $data['data'];
        }

        throw new \HttpException();
    }

    /**
     * @param string $division auto || moto
     * @param string $vin      17 char
     * @param string $locale   Default FR, accepted FR IT DE NL EN
     *
     * @return array|bool
     * @throws VehiculeNotFound
     */
    public function searchCampagnesCode($division, $vin, $locale = 'FR')
    {
        $code = $division === 'moto' ? 10 : 20;
        $res = $this->client->request('GET', $this->config['campagne_url'] . '/' . $code . '/' . $vin . '/' . $locale);

        $xml = simplexml_load_string($res->getBody()->getContents());

        if (preg_match('/^\s+$/', $xml->attributes()['messageCode'])) {
            $code = [];
            foreach ($xml->xpath('//updateDetail') as $XMLElement) {
                $code[ trim((string)$XMLElement->campaign) ] = trim((string)$XMLElement->description);
            }

            return $code;
        } elseif (trim($xml->attributes()['messageCode']) === 'HQL0001') {
            throw new VehiculeNotFound();
        }

        return false;
    }

    /**
     * @param string $division
     */
    public function setDivision($division)
    {
        if(is_string($division)) {
            $this->division = $division;
        }
    }
}
