<?php
/**
 * Created by IntelliJ IDEA.
 * User: Michel
 * Date: 04/04/2017
 * Time: 14:37
 */

namespace Bloom\Reminder;


use Bloom\Reminder\Services\ReminderApi;
use Illuminate\Support\ServiceProvider;

class ReminderApiServicesProvider extends ServiceProvider
{
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/../config/reminder_api.php' => config_path('reminder_api.php')
        ], 'config');
    }

    /**
     *
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/reminder_api.php', 'reminder_api');
        $this->app->singleton('ReminderApi', function () {
            return new ReminderApi(config('reminder_api'));
        });
        $this->app->alias('ReminderApi', Facades\ReminderApi::class);
    }


}