<?php
/**
 * Created by IntelliJ IDEA.
 * User: Michel
 * Date: 04/04/2017
 * Time: 15:59
 */

namespace Bloom\Reminder\Services;


use Bloom\Reminder\Error\VehiculeNotFound;
use Bloom\Reminder\Model\Vehicule;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

/**
 * Class ReminderApi
 * @package Bloom\Reminder\Services
 */
class ReminderApi
{
    protected $client;
    protected $config;

    /**
     * ReminderApi constructor.
     * @param array $config
     */
    public function __construct($config = [])
    {
        $this->client = new Client();
        $this->config = $config;
    }

    /**
     * @param string $immat Immatriculation a rechercher
     * @return mixed
     * @throws VehiculeNotFound
     */
    public function searchImmat($immat)
    {
        $res = $this->client->request('GET', $this->config['base_url'] . '/administration/api/vehicules/immat/' . $immat);
        $json = $res->getBody()->getContents();
        $data = \json_decode($json, true);
        if($data['status']) {
            return $data['data'];
        }

        throw new VehiculeNotFound();
    }

    /**
     * @param string $vin
     * @return mixed
     * @throws VehiculeNotFound
     */
    public function searchVin($vin)
    {
        $res = $this->client->request('GET', $this->config['base_url'] . '/administration/api/vehicules/vin/' . $vin);
        $json = $res->getBody()->getContents();
        $data = \json_decode($json, true);
        if($data['status']) {
            return $data['data'];
        }

        throw new VehiculeNotFound();
    }
}
