<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 04/04/2017
 * Time: 15:38
 */

namespace Bloom\Reminder\Services;

/**
 * Class ReminderApiTest
 * @package Bloom\Reminder\Services
 */
class ReminderApiTest extends \PHPUnit_Framework_TestCase
{
    public function getConfig()
    {
        static $config;
        if($config === null) {
            $config = require_once __DIR__.'/../../config/reminder_api.php';
        }
        return $config;
    }

    /**
     * @expectedException \Bloom\Reminder\Error\VehiculeNotFound
     */
    public function test_should_throw_not_found_exception()
    {
        $reminder = new ReminderApi($this->getConfig());
        $reminder->searchImmat('DP658MD');
    }

    /**
     * @expectedException \InvalidArgumentException
     * @expectedExceptionMessageRegExp /alpha-numeric/
     */
    public function test_should_reject_nonalphanum_immat()
    {
        $reminder = new ReminderApi($this->getConfig());
        $reminder->searchImmat('AB"é^$*');
    }

    /**
     * @expectedException \InvalidArgumentException
     * @expectedExceptionMessageRegExp /string/
     */
    public function test_should_reject_nonstring_immat()
    {
        $reminder = new ReminderApi($this->getConfig());
        $reminder->searchImmat(42);
    }

    public function test_should_return_a_vehicule_instance()
    {
        $reminder = new ReminderApi($this->getConfig());
        $vehicule = $reminder->searchImmat('DP658MP');
        static::assertInstanceOf('Bloom\Reminder\Model\Vehicule', $vehicule);
    }


    public function test_should_return_a_vehicule_instance_populate()
    {
        $reminder = new ReminderApi($this->getConfig());
        $vehicule = $reminder->searchImmat('DP658MP');
        static::assertInstanceOf('Bloom\Reminder\Model\Vehicule', $vehicule);
        static::assertEquals(914973, $vehicule->parc_codeConcession);
    }
}
