<?php

namespace Bloom\LaravelMagnews\Http\Controllers;

use App\Http\Controllers\Controller;
use Bloom\LaravelMagnews\Facades\MagnewsApi;
use Exception;
use Illuminate\Http\Request;
use Log;

class DatatableController extends Controller
{
    /**
     * @param Request $request
     * @return mixed
     * @throws Exception
     */
    public function upsertData(Request $request): mixed
    {
        try {

            $request->validate([
                'datatable_name' => 'required|string',
                'data' => 'required|array'
            ]);

            return MagnewsApi::upsertDatatableData($request->datatable_name, $request->data);
        } catch (Exception $e) {
            Log::error(__METHOD__ . $e->getMessage());
            throw $e;
        }


    }

}
