
## About laravel-magnews

Ce package sert à intéragir avec magnews.

Ce package est disponible sur satis. il est à installer dans le projet via composer.

## Package laravel-magnews

Ce package est développé avec la version de php : 8.2

Ce package est développé avec la version de node : 0.35.3

Ce package fait le lien avec l'API magnews via une connexion SOAP.
Il contient des methodes pour faciliter cette intéraction. 


### Configuraion du package
Ajouter dans le composer.json, dans la section "require" 
````
"bloom/laravel-magnews" : "*"
````
et
````

"repositories": [{
    "type": "composer",
    "url": "https://satis.all.justiceleague.bloom.pro"
}]
````
Ajouter ceci pour publier les configs automatiquement (facultatif):

````
php artisan vendor:publish --tag=brevo-config --ansi --force
````

Pour surcharger l'appel de magnews via soap (url) et la clé api (key), ajouter le .env les variables :

``MAGNEWS_URL``
``MAGNEWS_KEY``

### Publier les configs
````
php artisan vendor:publish --tag=magnews-config
````
ou
````
php artisan vendor:publish
````
et sélectionner le provider magnews
````
Which provider or tag's files would you like to publish?

Provider: Bloom\LaravelMagnews\Providers\MagnewsServiceProvider
````
Le fichier config/magnews.php est désormais dans les configs de votre projet.

## Exemple de ce que fait le package laravel-magnews
Désabonner un contact :
````
  use Bloom\LaravelMagnews\Facades\MagnewsApi;
  
  $response = MagnewsApi::unsubscribeContact('123', 26);
````
Utilisation de la facade MagnewsApi.

Appel de la fonction unsubscribeContact qui se trouve dans le fichier src/Services/MagnewsService.php.

Les paramètres : 
- le nomeUtente du contact sur magnews
- l'id de la base de données


## Liste des routes API
* POST       api/count-contacts ............................................................................. count-contacts › Bloom\LaravelMagnews\Http\Controllers\ContactController@countContacts  
* POST       api/enter-workflow ............................................................................ enter-workflow › Bloom\LaravelMagnews\Http\Controllers\WorkflowController@enterWorkflow  
* POST       api/enter-workflow-with-id-contact ............................... enter-workflow-with-id-contact › Bloom\LaravelMagnews\Http\Controllers\WorkflowController@enterWorkflowWithIdContact  
* GET|HEAD   api/get-all-bdd-infos ..................................................................... get-all-bdd-infos › Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getAllBDDInfos  
* POST       api/get-bdd-basic-infos ............................................................... get-bdd-basic-infos › Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getBDDBasicInfos  
* POST       api/get-bdd-field-by-id ................................................................ get-bdd-field-by-id › Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getBDDFieldById  
* POST       api/get-bdd-fields ............................................................................. get-bdd-fields › Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getBDDFields  
* POST       api/get-bdds-basic-infos ............................................................ get-bdds-basic-infos › Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getBDDsBasicInfos  
* POST       api/get-contact-from-primary-key ...................................... get-contact-from-primary-key › Bloom\LaravelMagnews\Http\Controllers\ContactController@getContactFromPrimaryKey  
* POST       api/get-contact/{idContact} ............................................. get-contact-from-id-contact › Bloom\LaravelMagnews\Http\Controllers\ContactController@getContactFromIdContact  
* POST       api/query-contacts ............................................................................. query-contacts › Bloom\LaravelMagnews\Http\Controllers\ContactController@queryContacts  
* POST       api/query-contacts-by-special-list ................................ query-contacts-by-special-list › Bloom\LaravelMagnews\Http\Controllers\ContactController@queryContactsBySpecialList  
* POST       api/save-contact ................................................................................... save-contact › Bloom\LaravelMagnews\Http\Controllers\ContactController@saveContact  
* POST       api/subscribe-contact .................................................................... subscribe-contact › Bloom\LaravelMagnews\Http\Controllers\ContactController@subscribeContact  
* POST       api/unsubscribe-contact .............................................................. unsubscribe-contact › Bloom\LaravelMagnews\Http\Controllers\ContactController@unsubscribeContact


## Liste des fonctions utilisable via la facade MagnewsApi
* @method static Mixed saveContact(array $contact, int $idDatabase) : save contact
* @method static Mixed subscribeContact(string $nomeUtente, int $idDatabase) : subscribe contact
* @method static Mixed unsubscribeContact(string $nomeUtente, int $idDatabase) : unsubscribe contact
* @method static Mixed getContactFromPrimaryKey(string $primaryKey, int $idDatabase) : get contact from primaryKey
* @method static Mixed getContactFromIdContact(string $idContact) : get contact from idContact
* @method static Mixed queryContactsAllFields(string $where, int $idDatabase) : query contacts all fields
* @method static Mixed queryCountContacts(string $where, int $idDatabase) : query count contacts
* @method static Mixed queryContactsBelongsToSpecialList(int $idSpecialList, int $idDatabase) : query contacts belong to special list
* @method static Mixed getBDDFieldById(string $id, int $idDatabase) : Returns the definition for a field in a DB contacts by id.
* @method static Mixed getBDDsBasicInfos() : Returns basic information about all Databases.
* @method static Mixed getBDDBasicInfosById(int $idDatabase) : Returns basic information about a Database.
* @method static Mixed getBDDFields(int $idDatabase) : Returns the definition of all fields for a Database.
* @method static Mixed enterWorkflowWithIdContact(int $idContact, string $key, array $options= []) : Execute a workflow with only id contact variable
* @method static Mixed enterWorkflow(array $contact, string $key, array $options= []) : Execute a workflow.



## Tests unitaires

Ce package contient des tests unitaires. 

Pour les lancer, utilisez la commande : 
`php8.2 artisan test --filter=<nomDuTest>`

Tous les tests unitaires sont executés avec les paramètres défini dans /phpunit.xml

### Liste des tests unitaires
* test_save_contact
* test_unsubscribe_contact_ok
* test_unsubscribe_contact_ko
* test_subscribe_contact_ok
* test_subscribe_contact_ko
* test_get_contact_from_nome_utente_ok
* test_get_contact_from_nome_utente_ko
* test_get_contact_from_id_contact_ok
* test_get_contact_from_id_contact_ko
* test_query_contacts_all_fields_ok
* test_query_contacts_all_fields_ko
* test_query_count_contacts_ok
* test_query_count_0_contacts
* test_query_contacts_belongs_to_special_list_ok
* test_query_contacts_belongs_to_special_list_ko
* test_get_BDD_field_by_id_ok
* test_get_BDD_field_by_id_ko
* test_get_BDDs_basic_infos_ok
* test_get_BDD_basic_infos_by_id_ok
* test_get_BDD_basic_infos_by_id_ko
* test_get_BDD_fields_ok
* test_get_BDD_fields_ko
* test_enter_workflow_id_contact_ok
* test_enter_workflow_id_contact_ko
* test_enter_workflow_ok
* test_enter_workflow_ko

## Les logs
Les logs de se package se situerons dans le storage/logs/laravel.log de votre projet (une fois ce package installé)


## Autres
