<?php

namespace Bloom\LaravelMagnews\Http\Controllers;

use App\Http\Controllers\Controller;
use Bloom\LaravelMagnews\Facades\MagnewsApi;
use Illuminate\Http\Request;

class NewsletterController extends Controller
{

    /**
     * @param Request $request
     * @return mixed
     */
    public function findNewsletterById(Request $request): mixed
    {
        $request->validate([
            'id_newsletter' => 'required|integer',
        ]);

        return MagnewsApi::findNewsletterById(
            $request->id_newsletter
        );
    }

    /**
     * @param Request $request
     * @return mixed
     */
    public function getSimpleMessageEvents(Request $request): mixed
    {
        $request->validate([
            'idsimplemessage' => 'nullable|integer',
            'idcontact' => 'nullable|integer',
            'idmessagetype' => 'nullable|integer',
            'idmessagecategory' => 'nullable|integer',
            'from' => 'nullable|string|date_format:d/m/Y H:i',
            'to' => 'nullable|string|date_format:d/m/Y H:i',
            'channel' => 'nullable|string',
        ]);

        return MagnewsApi::getSimpleMessageEvents(
            $request->idsimplemessage ?? null,
            $request->idcontact ?? null,
            $request->idmessagetype ?? null,
            $request->idmessagecategory ?? null,
            $request->from ?? null,
            $request->to ?? null,
            $request->channel ?? null,
        );
    }
}
