<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Bloom\LaravelMagnews\Http\Controllers\ContactController;
use Bloom\LaravelMagnews\Http\Controllers\DatabaseController;
use Bloom\LaravelMagnews\Http\Controllers\WorkflowController;
use Bloom\LaravelMagnews\Http\Controllers\SurveyController;
use Bloom\LaravelMagnews\Http\Controllers\NewsletterController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

//Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//    return $request->user();
//});


Route::group(['prefix' => '/api/magnews'], function () {
    Route::post('/save-contact', [ContactController::class, 'saveContact'])->name('save-contact');
    Route::post('/unsubscribe-contact', [ContactController::class, 'unsubscribeContact'])->name('unsubscribe-contact');
    Route::post('/subscribe-contact', [ContactController::class, 'subscribeContact'])->name('subscribe-contact');
    Route::post('/get-contact-from-primary-key', [ContactController::class, 'getContactFromPrimaryKey'])->name('get-contact-from-primary-key');
    Route::post('/get-contact/{idContact}', [ContactController::class, 'getContactFromIdContact'])->name('get-contact-from-id-contact');
    Route::post('/query-contacts', [ContactController::class, 'queryContacts'])->name('query-contacts');
    Route::post('/count-contacts', [ContactController::class, 'countContacts'])->name('count-contacts');
    Route::post('/query-contacts-by-special-list', [ContactController::class, 'queryContactsBySpecialList'])->name('query-contacts-by-special-list');
    Route::post('/get-bdd-field-by-id', [DatabaseController::class, 'getBDDFieldById'])->name('get-bdd-field-by-id');
    Route::post('/get-bdds-basic-infos', [DatabaseController::class, 'getBDDsBasicInfos'])->name('get-bdds-basic-infos');
    Route::post('/get-bdd-basic-infos', [DatabaseController::class, 'getBDDBasicInfos'])->name('get-bdd-basic-infos');
    Route::post('/get-bdd-fields', [DatabaseController::class, 'getBDDFields'])->name('get-bdd-fields');
    Route::get('/get-all-bdd-infos', [DatabaseController::class, 'getAllBDDInfos'])->name('get-all-bdd-infos');
    Route::post('/enter-workflow-with-id-contact', [WorkflowController::class, 'enterWorkflowWithIdContact'])->name('enter-workflow-with-id-contact');
    Route::post('/enter-workflow', [WorkflowController::class, 'enterWorkflow'])->name('enter-workflow');
    Route::post('/get-survey-results', [SurveyController::class, 'getSurveyResults'])->name('get-survey-results');
    Route::post('/get-survey-fields/{idSurvey}', [SurveyController::class, 'getSurveyFields'])->name('get-survey-fields');
    Route::post('/get-survey-results-formatted', [SurveyController::class, 'getSurveyResultsFormatted'])->name('get-survey-results-formatted');
    Route::post('/execute-query', [ContactController::class, 'executeQuery'])->name('execute-query');
    Route::post('/find-newsletter-by-id', [NewsletterController::class, 'findNewsletterById'])->name('find-newsletter-by-id');
    Route::post('/get-simple-message-events', [NewsletterController::class, 'getSimpleMessageEvents'])->name('get-simple-message-events');
    Route::post('/create-ics-event', [ContactController::class, 'createIcsEvent'])->name('create-ics-event');
});
