<?php

namespace Bloom\LaravelMagnews\Services;

use Bloom\LaravelMagnews\DOT\Credentials;

class MagnewsSoap extends \SoapClient
{
    /**
     * @var Credentials|null
     */
    public ?Credentials $credentials;

    /**
     * @param Credentials $credentials
     * @return void
     */
    public function setCredentials(Credentials $credentials): void
    {
        $this->credentials = $credentials;
    }

    /**
     * @param string $name
     * @param array $args
     * @return mixed
     */
    public function __call(string $name, array $args = [])
    {
        if (!array_key_exists('credentials', $args[0])) {
            $args[0]['credentials'] = $this->credentials->toArray();
        }
        return parent::__call($name, $args);
    }
}
