<?php

namespace Bloom\LaravelMagnews\Http\Controllers;
use App\Http\Controllers\Controller;
use Bloom\LaravelMagnews\Facades\MagnewsApi;
use Illuminate\Http\Request;

class DatabaseController extends Controller
{

    /**
     * @param Request $request
     * @return Mixed
     */
    public function getBDDFieldById(Request $request): mixed
    {

        $request->validate([
            'id_field' => 'required|string',
            'id_database' => 'required|integer'
        ]);

        return MagnewsApi::getBDDFieldById( $request->get('id_field'), $request->get('id_database'));
    }

    /**
     * @return Mixed
     */
    public function getBDDsBasicInfos(): mixed
    {
        return MagnewsApi::getBDDsBasicInfos();
    }
    /**
     * @param Request $request
     * @return Mixed
     */
    public function getBDDBasicInfos(Request $request): mixed
    {
        $request->validate([
            'id_database' => 'required|integer'
        ]);

        return MagnewsApi::getBDDBasicInfosById($request->get('id_database'));
    }
    /**
     * @param Request $request
     * @return Mixed
     */
    public function getBDDFields(Request $request): mixed
    {
        $request->validate([
            'id_database' => 'required|integer'
        ]);

        return MagnewsApi::getBDDFields($request->get('id_database'));
    }

    /**
     * @return array
     */
    public function getAllBDDInfos(): array
    {
        $allBdd = MagnewsApi::getBDDsBasicInfos();

        foreach ($allBdd as $bdd){
            $bdd->fields = MagnewsApi::getBDDFields($bdd->idDatabase);
        }
        return $allBdd;
    }
}
