<?php

namespace Bloom\LaravelMagnews\Http\Controllers;

use App\Http\Controllers\Controller;
use Bloom\LaravelMagnews\Facades\MagnewsApi;
use Illuminate\Http\Request;

class SurveyController extends Controller
{

    /**
     * @param Request $request
     * @return mixed
     */
    public function getSurveyResults(Request $request): mixed
    {
        $request->validate([
            'id_survey' => 'required|string',
            'from' => 'nullable|date',
            'to' => 'nullable|date',
            'show_anonymous' => 'nullable|boolean',
            'show_uncompleted' => 'nullable|boolean',
        ]);

        return MagnewsApi::getSurveyResults(
            $request->id_survey,
            $request->from ?? null,
            $request->to ?? null,
            $request->show_anonymous ?? true,
            $request->show_uncompleted ?? true);
    }

    /**
     * @param String $idSurvey
     * @return mixed
     */
    public function getSurveyFields(string $idSurvey): mixed
    {
        return MagnewsApi::getSurveyFields($idSurvey);
    }

    /**
     * @param Request $request
     * @return mixed
     */
    public function getSurveyResultsFormatted(Request $request): mixed
    {
        $request->validate([
            'id_survey' => 'required|string',
            'from' => 'nullable',
            'to' => 'nullable',
            'show_anonymous' => 'nullable|boolean',
            'show_uncompleted' => 'nullable|boolean',
            'need_contact_fields' => 'nullable|boolean',
            'contact_fields_selected' => 'nullable|array',
            'not_ignore_leads_test' => 'nullable|boolean',
            'not_ignore_sessions_test' => 'nullable|boolean',
            'filter_results_by_this_week' => 'nullable|boolean',
            'first_day_of_the_week' => 'nullable|string',
        ]);

        //récupère les résultats du survey
        return MagnewsApi::getSurveyResultsFormatted(
            $request->id_survey,
            $request->from ? date_create($request->from) : null,
            $request->to ? date_create($request->to) : null,
            $request->show_anonymous ?? true,
            $request->show_uncompleted ?? true,
            $request->need_contact_fields ?? false,
            $request->contact_fields_selected ?? null,
            $request->not_ignore_leads_test ?? false,
            $request->not_ignore_sessions_test ?? false,
            $request->filter_results_by_this_week ?? false,
            $request->first_day_of_the_week ?? 'monday',
        );
    }
}
