<?php

namespace Bloom\LaravelMagnews\Providers;

use Bloom\LaravelMagnews\Services\MagnewsService;
use Illuminate\Support\ServiceProvider;


class MagnewsServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     * @return void
     */
    public function boot(): void
    {
        $this->publishes([
            __DIR__ . '/../../config/magnews.php' => config_path('magnews.php'),
        ], 'magnews-config');

        include __DIR__ . '/../../routes/api.php';
    }

    /**
     * Register bindings in the container.
     * @return void
     * @throws \SoapFault
     */
    public function register(): void
    {
        $this->app->bind(MagnewsService::class,
            $this->app->singleton(MagnewsService::class, function ($app) {
                return new MagnewsService();
            }));
    }
}
