<?php

namespace Bloom\LaravelMagnews\Http\Controllers;
use App\Http\Controllers\Controller;
use Bloom\LaravelMagnews\Facades\MagnewsApi;
use Illuminate\Http\Request;

class WorkflowController extends Controller
{

    /**
     * @param Request $request
     * @return Bool
     */
    public function enterWorkflowWithIdContact(Request $request): bool
    {
        $request->validate([
            'id_contact' => 'required|integer',
            'key' => 'required|string',
            'options' => 'nullable|array'
        ]);

        return MagnewsApi::enterWorkflowWithIdContact( $request->get('id_contact'), $request->get('key'), $request->get('options')?? []);
    }
    /**
     * @param Request $request
     * @return Bool
     */
    public function enterWorkflow(Request $request): bool
    {

        $request->validate([
            'contact' => 'required|array',
            'key' => 'required|string',
            'options' => 'nullable|array'
        ]);

        return MagnewsApi::enterWorkflow( $request->get('contact'), $request->get('key'), $request->get('options')?? []);
    }


}
