<?php

namespace Bloom\LaravelMagnews\Services;

use Illuminate\Support\Facades\Http;

class MagnewsRest
{

    private static string $url;
    private static string $accessToken;

    public function __construct()
    {
        self::$accessToken = config('magnews.rest_access_token');
        self::$url = config('magnews.rest_url');
    }


    /**
     * @param string $uri
     * @param array $args
     * @return mixed
     */
    public static function call(string $uri, array $args = []): mixed
    {
        return Http::post(self::$url . $uri . '?access_token=' . self::$accessToken, $args);
    }
}
