<?php

namespace Bloom\LaravelMagnews\Http\Controllers;

use App\Http\Controllers\Controller;
use Bloom\LaravelMagnews\Facades\MagnewsApi;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    /**
     * @param Request $request
     * @return Mixed
     */
    public function saveContact(Request $request): mixed
    {

        $request->validate([
            'id_database' => 'required|integer',
            'contact' => 'required'
        ]);

        return MagnewsApi::saveContact($request->get('contact'), $request->get('id_database'));
    }

    /**
     * @param Request $request
     * @return Mixed
     */
    public function subscribeContact(Request $request): mixed
    {

        $request->validate([
            'id_database' => 'required|integer',
            'nome_utente' => 'required'
        ]);

        return MagnewsApi::subscribeContact($request->get('nome_utente'), $request->get('id_database'));
    }

    /**
     * @param Request $request
     * @return Mixed
     */
    public function unsubscribeContact(Request $request): mixed
    {
        $request->validate([
            'id_database' => 'required|integer',
            'nome_utente' => 'required'
        ]);

        return MagnewsApi::unsubscribeContact($request->get('nome_utente'), $request->get('id_database'));
    }

    /**
     * @param Request $request
     * @return Mixed
     */
    public function getContactFromPrimaryKey(Request $request): mixed
    {

        $request->validate([
            'id_database' => 'required|integer',
            'primary_key' => 'required'
        ]);

        return MagnewsApi::getContactFromPrimaryKey($request->get('primary_key'), $request->get('id_database'));
    }

    /**
     * @param String $idContact
     * @return Mixed
     */
    public function getContactFromIdContact(string $idContact): mixed
    {
        return MagnewsApi::getContactFromIdContact($idContact);
    }

    /**
     * @param Request $request
     * @return Mixed
     */
    public function queryContacts(Request $request): mixed
    {

        $request->validate([
            'id_database' => 'required|integer',
            'where' => 'required|string'
        ]);

        return MagnewsApi::queryContactsAllFields($request->get('id_database'), $request->get('where'));
    }

    /**
     * @param Request $request
     * @return Mixed
     */
    public function countContacts(Request $request): mixed
    {

        $request->validate([
            'id_database' => 'required|integer',
            'where' => 'required|string'
        ]);

        return MagnewsApi::queryCountContacts($request->get('where'), $request->get('id_database'));
    }

    /**
     * @param Request $request
     * @return Mixed
     */
    public function queryContactsBySpecialList(Request $request): mixed
    {

        $request->validate([
            'id_database' => 'required|integer',
            'id_list' => 'required|integer'
        ]);

        return MagnewsApi::queryContactsBelongsToSpecialList($request->get('id_list'), $request->get('id_database'));
    }

    /**
     * @param Request $request
     * @return Mixed
     */
    public function executeQuery(Request $request): mixed
    {

        $request->validate([
            'query' => 'required|string',
        ]);

        return MagnewsApi::executeQuery($request->get('query'));
    }

    public function createIcsEvent(Request $request): mixed
    {
        $request->validate([
            'title' => 'required|string',
            'description' => 'nullable|string',
            'start_date' => 'required|string',
            'end_date' => 'nullable|string',
            'email' => 'nullable|email',
            'nome_utente' => 'nullable|string',
        ]);

        return MagnewsApi::createICSEvent(
            $request->get('title'),
            date_create($request->get('start_date')),
            $request->get('end_date') ? date_create($request->get('end_date')) : null,
            $request->get('description') ?? null,
            $request->get('email') ?? null,
            $request->get('nome_utente') ?? null,
        );

    }
}
