## About laravel-magnews

Ce package sert à intéragir avec magnews.

Ce package est disponible sur satis. il est à installer dans le projet via composer.

## Package laravel-magnews

Ce package est développé avec la version de php : 8.2

Ce package est développé avec la version de node : 0.35.3

Ce package fait le lien avec l'API magnews via une connexion SOAP.
Il contient des methodes pour faciliter cette intéraction.

### Configuraion du package

Ajouter dans le composer.json, dans la section "require"

````
"bloom/laravel-magnews" : "*"
````

et

````

"repositories": [{
    "type": "composer",
    "url": "https://satis.all.justiceleague.bloom.pro"
}]
````

Ajouter ceci pour publier les configs automatiquement (facultatif):

````
php artisan vendor:publish --tag=magnews-config --ansi --force
````

#### les variables du .env

Pour surcharger l'appel de magnews via soap (url) et la clé api (key), ajouter le .env les variables :

``MAGNEWS_URL``
``MAGNEWS_KEY``

Surcharger le mail par défaut pour le création d'une entrée dans la table ics_events de magnews

``MAGNEWS_ICS_EVENTS_DEFAULT_MAIL`` : 'support@bloom-multimedia.fr'

### Publier les configs

````
php artisan vendor:publish --tag=magnews-config
````

ou

````
php artisan vendor:publish
````

et sélectionner le provider magnews

````
Which provider or tag's files would you like to publish?

Provider: Bloom\LaravelMagnews\Providers\MagnewsServiceProvider
````

Le fichier config/magnews.php est désormais dans les configs de votre projet.

## Exemple de ce que fait le package laravel-magnews

Désabonner un contact :

````
  use Bloom\LaravelMagnews\Facades\MagnewsApi;
  
  $response = MagnewsApi::unsubscribeContact('123', 26);
````

Utilisation de la facade MagnewsApi.

Appel de la fonction unsubscribeContact qui se trouve dans le fichier src/Services/MagnewsService.php.

Les paramètres :

- le nomeUtente du contact sur magnews
- l'id de la base de données

## Liste des routes API

- POST api/magnews/count-contacts ..................................................................... count-contacts ›
  Bloom\LaravelMagnews\Http\Controllers\ContactController@countContacts
- POST api/magnews/create-ics-event ................................................................ create-ics-event ›
  Bloom\LaravelMagnews\Http\Controllers\ContactController@createIcsEvent
- POST api/magnews/enter-workflow .................................................................... enter-workflow ›
  Bloom\LaravelMagnews\Http\Controllers\WorkflowController@enterWorkflow
- POST api/magnews/enter-workflow-with-id-contact ....................... enter-workflow-with-id-contact ›
  Bloom\LaravelMagnews\Http\Controllers\WorkflowController@enterWorkflowWithIdContact
- POST api/magnews/execute-query ........................................................................
  execute-query › Bloom\LaravelMagnews\Http\Controllers\ContactController@executeQuery
- POST api/magnews/find-newsletter-by-id ............................................... find-newsletter-by-id ›
  Bloom\LaravelMagnews\Http\Controllers\NewsletterController@findNewsletterById
- GET|HEAD api/magnews/get-all-bdd-infos .............................................................
  get-all-bdd-infos › Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getAllBDDInfos
- POST api/magnews/get-bdd-basic-infos ....................................................... get-bdd-basic-infos ›
  Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getBDDBasicInfos
- POST api/magnews/get-bdd-field-by-id ........................................................ get-bdd-field-by-id ›
  Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getBDDFieldById
- POST api/magnews/get-bdd-fields ..................................................................... get-bdd-fields ›
  Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getBDDFields
- POST api/magnews/get-bdds-basic-infos .................................................... get-bdds-basic-infos ›
  Bloom\LaravelMagnews\Http\Controllers\DatabaseController@getBDDsBasicInfos
- POST api/magnews/get-contact-from-primary-key .............................. get-contact-from-primary-key ›
  Bloom\LaravelMagnews\Http\Controllers\ContactController@getContactFromPrimaryKey
- POST api/magnews/get-contact/{idContact} ..................................... get-contact-from-id-contact ›
  Bloom\LaravelMagnews\Http\Controllers\ContactController@getContactFromIdContact
- POST api/magnews/get-simple-message-events ................................... get-simple-message-events ›
  Bloom\LaravelMagnews\Http\Controllers\NewsletterController@getSimpleMessageEvents
- POST api/magnews/get-survey-fields/{idSurvey} ................................................... get-survey-fields ›
  Bloom\LaravelMagnews\Http\Controllers\SurveyController@getSurveyFields
- POST api/magnews/get-survey-results ........................................................... get-survey-results ›
  Bloom\LaravelMagnews\Http\Controllers\SurveyController@getSurveyResults
- POST api/magnews/get-survey-results-formatted .............................. get-survey-results-formatted ›
  Bloom\LaravelMagnews\Http\Controllers\SurveyController@getSurveyResultsFormatted
- POST api/magnews/query-contacts ..................................................................... query-contacts ›
  Bloom\LaravelMagnews\Http\Controllers\ContactController@queryContacts
- POST api/magnews/query-contacts-by-special-list ........................ query-contacts-by-special-list ›
  Bloom\LaravelMagnews\Http\Controllers\ContactController@queryContactsBySpecialList
- POST api/magnews/save-contact ...........................................................................
  save-contact › Bloom\LaravelMagnews\Http\Controllers\ContactController@saveContact
- POST api/magnews/subscribe-contact ............................................................ subscribe-contact ›
  Bloom\LaravelMagnews\Http\Controllers\ContactController@subscribeContact
- POST api/magnews/unsubscribe-contact ...................................................... unsubscribe-contact ›
  Bloom\LaravelMagnews\Http\Controllers\ContactController@unsubscribeContact
- POST api/magnews/upsert-datatable-data ........................................................
  upsert-datatable-data › Bloom\LaravelMagnews\Http\Controllers\DatatableController@upsertData

## Liste des fonctions utilisable via la facade MagnewsApi

* @method static Mixed saveContact(array $contact, int $idDatabase) : save contact
* @method static Mixed subscribeContact(string $nomeUtente, int $idDatabase) : subscribe contact
* @method static Mixed unsubscribeContact(string $nomeUtente, int $idDatabase) : unsubscribe contact
* @method static Mixed getContactFromPrimaryKey(string $primaryKey, int $idDatabase) : get contact from primaryKey
* @method static Mixed getContactFromIdContact(string $idContact) : get contact from idContact
* @method static Mixed queryContactsAllFields(int $idDatabase,string $where) : query contacts all fields
* @method static Mixed queryCountContacts(string $where, int $idDatabase) : query count contacts
* @method static Mixed queryContactsBelongsToSpecialList(int $idSpecialList, int $idDatabase) : query contacts belong to
  special list
* @method static Mixed getBDDFieldById(string $id, int $idDatabase) : Returns the definition for a field in a DB
  contacts by id.
* @method static Mixed getBDDsBasicInfos() : Returns basic information about all Databases.
* @method static Mixed getBDDBasicInfosById(int $idDatabase) : Returns basic information about a Database.
* @method static Mixed getBDDFields(int $idDatabase) : Returns the definition of all fields for a Database.
* @method static Mixed enterWorkflowWithIdContact(int $idContact, string $key, array $options = []) : Execute a workflow
  with only id contact variable
* @method static Mixed enterWorkflow(array $contact, string $key, array $options = []) : Execute a workflow.
* @method static Mixed getFormSubmissionsResults(string $idPage, DateTime $from = null, DateTime $to = null, Bool
  $showAnonymous = true) : récupère les résultats d'un formulaire
* @method static Mixed getSurveyResults(string $idSurvey, DateTime $from = null, DateTime $to = null, Bool
  $showAnonymous = true, Bool $showUncompleted = true) : récupère les résultats d'un survey
* @method static Mixed getSurveyFields(string $idSurvey) : récupère les champs d'un survey
* @method static Mixed getSurveyResultsFormatted(string $idSurvey, DateTime $from = null, DateTime $to = null, Bool
  $showAnonymous = true, Bool $showUncompleted = true, Bool $needContactFields = false, array $contactFieldsSelected =
  null, Bool $notIgnoreLeadsTest = false, Bool $notIgnoreSessionsTest = false, Bool $filterResultsByThisWeek = false,
  string $firstDayOfTheWeek = 'monday', Bool $filterResultsByLastWeek = false) : formate les résultats d'un survey
* @method static Mixed subscribeContactToList(int $idDatabase, int $idList, $primaryKeyValue, $idSubscriptionCause =
  null) : Fonction permettant d'abonner un contact à une liste spéciale dans Magnews
* @method static Mixed findCampaignById(int $idCampaign): Fonction qui récupère les infos de base d'une compagne
* @method static Mixed findNewsletterById(int $idNewsletter): Fonction qui récupère les infos de base d'une newsletter
* @method static Mixed getSimpleMessageEvents(int $idSimpleMessage = null, int $idContact = null, int $idMessageType =
  null, int $idMessageCategory = null, string $from = null, string $to = null, string $channel = null):
* @method static Mixed getDeliveryStatusForNewsletter(int $idNewsletter):
* @method static Mixed queryDeliveryStatusForCampaign(int $idCampaign):
* @method static Mixed getBasicNewsletterReport(int $idNewsletter):
* @method static Mixed queryDetailedNewsletterReport(int $idNewsletter, array $options = []):
* @method static Mixed queryDetailedContactReport(int $idContact, array $options = []):
* @method static Mixed executeQuery(string $query):
* @method static Mixed createICSEvent(string $title, DateTime $start_date, ?DateTime $end_date = null, ?string
  $description = null, ?string $email = 'support@bloom-multimedia.fr', ?string $nome_utente = null) : create an entry in
  ics_events table
* @method static Mixed upsertDatatableData(string $databaseName, array $data) : upsert data in datatables

## Tests unitaires

Ce package contient des tests unitaires.

Pour les lancer, utilisez la commande :
`php8.2 artisan test --filter=<nomDuTest>`

Tous les tests unitaires sont executés avec les paramètres défini dans /phpunit.xml

### Liste des tests unitaires

* test_save_contact
* test_unsubscribe_contact_ok
* test_unsubscribe_contact_ko
* test_subscribe_contact_ok
* test_subscribe_contact_ko
* test_get_contact_from_nome_utente_ok
* test_get_contact_from_nome_utente_ko
* test_get_contact_from_id_contact_ok
* test_get_contact_from_id_contact_ko
* test_query_contacts_all_fields_ok
* test_query_contacts_all_fields_ko
* test_query_count_contacts_ok
* test_query_count_0_contacts
* test_query_contacts_belongs_to_special_list_ok
* test_query_contacts_belongs_to_special_list_ko
* test_get_BDD_field_by_id_ok
* test_get_BDD_field_by_id_ko
* test_get_BDDs_basic_infos_ok
* test_get_BDD_basic_infos_by_id_ok
* test_get_BDD_basic_infos_by_id_ko
* test_get_BDD_fields_ok
* test_get_BDD_fields_ko
* test_enter_workflow_id_contact_ok
* test_enter_workflow_id_contact_ko
* test_enter_workflow_ok
* test_enter_workflow_ko
* test_get_form_submissions_results_empty
* test_get_survey_results_completed
* test_get_all_fields_in_survey
* test_subscribe_to_special_list_ko
* test_subscribe_to_special_list_ok
* test_find_campaign_by_id_ok
* test_find_campaign_by_id_ko
* test_find_newsletter_by_id_ok
* test_find_newsletter_by_id_ko
* test_get_simple_message_events
* test_get_delivery_status_for_newsletter
* test_get_delivery_status_for_campaign
* test_get_delivery_status_for_campaign_ko
* test_get_basic_newsletter_report
* test_get_basic_newsletter_report_ko
* test_query_detailed_newsletter_report
* test_query_detailed_contact_report
* test_query
* test_create_ics_event_ok_basic
* test_create_ics_event_ok_full
* test_update_datatable_data_ok

## Les logs

Les logs de ce package sont dans le storage/logs/laravel.log de votre projet (une fois ce package installé)

## Erreurs

``
SoapFault: SoapClient::__construct(): &#039;location&#039; and &#039;uri&#039; options are required in nonWSDL mode in file /var/www/christelle/bl-notifications-mails/vendor/bloom/laravel-magnews/src/Services/MagnewsService.php on line 23
``

Le package n'est pas installé correctement.
Publier les assets : ``php artisan vendor:publish --tag=magnews-config``
