<?php

namespace Bloom\LaravelMagnews\Facades;

use Bloom\LaravelMagnews\Services\MagnewsService;
use DateTime;
use Illuminate\Support\Facades\Facade;

/**
 * Class MagnewsApi
 * @package Bloom\LaravelMagnews\Facades
 * @see MagnewsService
 * @method static Mixed saveContact(array $contact, int $idDatabase) : save contact
 * @method static Mixed subscribeContact(string $primaryFieldValue, int $idDatabase, string $primaryFieldName = 'NOME_UTENTE') : subscribe contact
 * @method static Mixed unsubscribeContact(string $nomeUtente, int $idDatabase) : unsubscribe contact
 * @method static Mixed getContactFromPrimaryKey(string $primaryKey, int $idDatabase) : get contact from primaryKey
 * @method static Mixed getContactFromIdContact(string $idContact) : get contact from idContact
 * @method static Mixed queryContactsAllFields(int $idDatabase, string $where = '') : query contacts all fields
 * @method static Mixed queryCountContacts(string $where, int $idDatabase) : query count contacts
 * @method static Mixed queryContactsBelongsToSpecialList(int $idSpecialList, int $idDatabase) : query contacts belong to special list
 * @method static Mixed getBDDFieldById(string $id, int $idDatabase) : Returns the definition for a field in a DB contacts by id.
 * @method static Mixed getBDDsBasicInfos() : Returns basic information about all Databases.
 * @method static Mixed getBDDBasicInfosById(int $idDatabase) : Returns basic information about a Database.
 * @method static Mixed getBDDFields(int $idDatabase) : Returns the definition of all fields for a Database.
 * @method static Mixed enterWorkflowWithIdContact(int $idContact, string $key, array $options = []) : Execute a workflow with only id contact variable
 * @method static Mixed enterWorkflow(array $contact, string $key, array $options = []) : Execute a workflow.
 * @method static Mixed getFormSubmissionsResults(string $idPage, DateTime $from = null, DateTime $to = null, Bool $showAnonymous = true) : récupère les résultats d'un formulaire
 * @method static Mixed getSurveyResults(string $idSurvey, DateTime $from = null, DateTime $to = null, Bool $showAnonymous = true, Bool $showUncompleted = true) : récupère les résultats d'un survey
 * @method static Mixed getSurveyFields(string $idSurvey) : récupère les champs d'un survey
 * @method static Mixed getSurveyResultsFormatted(string $idSurvey, DateTime $from = null, DateTime $to = null, Bool $showAnonymous = true, Bool $showUncompleted = true, Bool $needContactFields = false, array $contactFieldsSelected = null, Bool $notIgnoreLeadsTest = false, Bool $notIgnoreSessionsTest = false, Bool $filterResultsByThisWeek = false, string $firstDayOfTheWeek = 'monday', Bool $filterResultsByLastWeek = false) : formate les résultats d'un survey
 * @method static Mixed subscribeContactToList(int $idDatabase, int $idList, $primaryKeyValue, $idSubscriptionCause = null) : Fonction permettant d'abonner un contact à une liste spéciale dans Magnews
 * @method static Mixed findCampaignById(int $idCampaign): Fonction qui récupère les infos de base d'une compagne
 * @method static Mixed findNewsletterById(int $idNewsletter): Fonction qui récupère les infos de base d'une newsletter
 * @method static Mixed getSimpleMessageEvents(int $idSimpleMessage = null, int $idContact = null, int $idMessageType = null, int $idMessageCategory = null, string $from = null, string $to = null, string $channel = null):
 * @method static Mixed getDeliveryStatusForNewsletter(int $idNewsletter):
 * @method static Mixed queryDeliveryStatusForCampaign(int $idCampaign):
 * @method static Mixed getBasicNewsletterReport(int $idNewsletter):
 * @method static Mixed queryDetailedNewsletterReport(int $idNewsletter, array $options = []):
 * @method static Mixed queryDetailedContactReport(int $idContact, array $options = []):
 * @method static Mixed executeQuery(string $query):
 * @method static Mixed createICSEvent(string $title, DateTime $start_date, ?DateTime $end_date = null, ?string $description = null, ?string $email = 'support@bloom-multimedia.fr', ?string $nome_utente = null) : create an entry in ics_events table
 * @method static Mixed upsertDatatableData(string $databaseName, array $data) : upsert data in datatables
 */
class MagnewsApi extends Facade
{
    /**
     * Get the registered name of the component.
     * @return MagnewsService
     */
    protected static function getFacadeAccessor(): MagnewsService
    {
        return app(MagnewsService::class);
    }

    public static function __callStatic($method, $args)
    {
        return (static::getFacadeAccessor())->$method(...$args);
    }
}
