<?php

namespace Bloom\LaravelMagnews\Http\Controllers;
use App\Http\Controllers\Controller;
use Bloom\LaravelMagnews\Facades\MagnewsApi;
use Illuminate\Http\Request;

class SurveyController extends Controller
{

    /**
     * @param Request $request
     * @return mixed
     */
    public function getSurveyResults(Request $request): mixed
    {
        $request->validate([
            'id_survey' => 'required|string',
            'from' => 'nullable|date',
            'to' => 'nullable|date',
            'show_anonymous' => 'nullable|boolean',
            'show_uncompeted' => 'nullable|boolean',
        ]);

        return MagnewsApi::getSurveyResults( $request->get('id_survey'), $request->get('from')?? null, $request->get('to')?? null, $request->get('show_anonymous')?? true,$request->get('show_uncompeted')?? true);
    }

    /**
     * @param String $idSurvey
     * @return mixed
     */
    public function getSurveyFields(String $idSurvey): mixed
    {
        return MagnewsApi::getSurveyFields($idSurvey);
    }

}
