<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 04/04/2017
 * Time: 15:00
 */

namespace Bloom\Honda\Services;

class HondaSSOTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @expectedException \InvalidArgumentException
     * @expectedExceptionMessageRegExp /15 char/
     */
    public function test_should_reject_less_than_15_char_hash()
    {
        $HondaSSO = new HondaSSO('');
        $HondaSSO->verifyHash('ABCDEF12345678');
    }


    /**
     * @expectedException \InvalidArgumentException
     * @expectedExceptionMessageRegExp /alpha-numeric/
     */
    public function test_should_reject_non_alpha_num_hash()
    {
        $HondaSSO = new HondaSSO('');
        $HondaSSO->verifyHash('ABCDEF12!45(7{!');
    }
}
