<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 30/03/2017
 * Time: 12:51
 */

namespace Bloom\Honda\Error;

use Psr\Http\Message\ResponseInterface;
use Throwable;

class HttpSSOException extends \Exception
{
    /**
     * @var null|ResponseInterface
     */
    protected $response;

    /**
     * HttpSSOException constructor.
     * @param string                 $message
     * @param ResponseInterface|null $response
     * @param int                    $code
     * @param Throwable|null         $previous
     */
    public function __construct($message = "", ResponseInterface $response = null, $code = 0, Throwable $previous = null)
    {
        $this->response = $response;
        parent::__construct($message, $code, $previous);
    }

    /**
     * @return ResponseInterface
     */
    public function getResponse()
    {
        return $this->response;
    }
}
