<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 30/03/2017
 * Time: 11:12
 */

namespace Bloom\Honda;

use Bloom\Honda\Services\HondaSSO;
use Illuminate\Support\ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../config/honda_auth.php' => config_path('honda_auth.php')
        ]);
    }

    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/honda_auth.php', 'honda_auth');

        $this->app->singleton('HondaSSO', function() {
            return new HondaSSO(config('honda_auth.url'));
        });
    }
}
