<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 30/03/2017
 * Time: 12:38
 */

namespace Bloom\Honda\Model;

class HondaUser
{
    public $email;
    public $username;
    public $fullname;
    public $dealer;
    public $country_code;

    /**
     * Get the country short code for the current country code Honda
     * @return string|false Return the short code of the country or false if not found
     */
    public function getCountry()
    {
        $country = config('honda_auth.country');
        if(array_key_exists($this->country_code, $country)) {
            return $country[$this->country_code];
        }
        return false;
    }
}
