<?php

namespace Bloom\CMSHelper;

use Illuminate\Support\ServiceProvider;


class CMSHelperServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/../config/cms_helper.php' =>  config_path('cms_helper.php')
        ], 'config');
        $this->loadViewsFrom(__DIR__ . '/Views/error_mail_admin.twig', 'mails');
        $this->publishes([
            __DIR__ . '/Views/error_mail_admin.twig' => resource_path('views/vendor/mails/error_mail_admin'),
        ]);
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/cms_helper.php', 'cms_helper');
        $this->app->singleton('CMSHelper', function(){
            return new Service\CMSHelper(config('cms_helper'));
        });
        $this->app->alias('CMSHelper', Facades\CMSHelper::class);
    }
}
