<?php

namespace Bloom\CMSHelper\Model;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InfoMail extends Mailable
{
    use Queueable, SerializesModels;

    public $domaine;
    public $textError;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($message)
    {
        $this->domaine = env('APP_DOMAIN');
        $this->textInfo = $message;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('mails.info_mail_admin')->from('admin@bloom-multimedia.fr')->subject('[Info CMS] : '.$this->domaine);
    }
}
