<?php

namespace Bloom\CMSHelpers\Model;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ErrorMail extends Mailable
{
    use Queueable, SerializesModels;

    public $domaine;
    public $textError;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($message)
    {
        $this->domaine = env('APP_DOMAIN');
        $this->textError = $message;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('vendor.mails.error_mail_admin')->from('admin@bloom-multimedia.fr')->subject('[Erreur CMS] : '.$this->domaine);
    }
}
