<?php


namespace Bloom\CMSHelper;

class CMSHelperTest extends \PHPUnit_Framework_TestCase
{
    public function getConfig()
    {
        static $config;
        if($config === null) {
            $config = require_once __DIR__.'/../../config/cms_helper.php';
        }
        return $config;
    }

    /**
     * @return mixed
     * @depends getConfig
     */
    public function testGetAdminsArray($config){
        $this->assertArrayhasKey('administrators', $config);

        $array = $config['administrators'];

        $this->assertNotEmpty($array);

        return $array;
    }

    /**
     * Je test qu'une fois changé en chaîne de caractères pour l'envoi de mail
     * @depends getConfig
     */
    public function testSplitedAdmins($config){
        $adminsListString = '';
        foreach($config as $admin){
            $adminsListString .= ','.$admin;
        }
        $this->assertNotEmpty($adminsListString);
    }
}
