<?php

namespace Bloom\CMSHelper\Service;

use Bloom\CMSHelper\Model\ErrorMail;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Mail;

class CMSHelper implements ErrorHelperInterface
{
    private $adminsMail;

    public function __construct($config = [])
    {
        foreach ($config['administrators'] as $admin) {
            $this->adminsMail .= $admin;
        }
    }

    public function getErrorArrayResponse($status, $message, $erreur)
    {
        $this->sendErrorMail($erreur);

        return response()->json([
            'status' => $status,
            'message' => $message
        ], Response::HTTP_OK);
    }

    public function sendErrorMail($body)
    {
        Mail::to($this->adminsMail)->send(new ErrorMail($body));
    }
}
