<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 05/07/18
 * Time: 12:09
 */

namespace Bloom\LaravelBrevo;


use Exception;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;
use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumberFormat;
use libphonenumber\PhoneNumberUtil;
use Brevo\Client\Api\TransactionalSMSApi;
use Brevo\Client\Configuration;
use Brevo\Client\Model\SendTransacSms;


class BrevoSmsTransport
{
    /**
     * @var Configuration
     */
    protected $config;
    /**
     * @var string
     */
    protected $tag;

    public function __construct()
    {
        $this->config = Configuration::getDefaultConfiguration()->setApiKey('api-key', config('brevo.key'));
    }

    /**
     * @param array $data = ['region'=> optional(par défaut : FR), 'to' => required; 'from'=> required, 'tag'=> optional (par défaut: S-HONDA-CH)]
     * @return bool
     * @throws BrevoException
     */

    public function send(Array $data): bool
    {
        $phoneUtil = PhoneNumberUtil::getInstance();
        try {
            if(empty($data['region'])){
                $data['region'] = 'FR';
            }
            if(empty($data['tag'])){
                $data['tag'] = config('brevo.tag');
            }
            $number = $phoneUtil->parse($data['to'], $data['region']);
        } catch (NumberParseException $e) {

            Log::error("Invalid phone number given", ['number' => $data['to'], 'region'=> $data['region']]);
            throw new BrevoException("Invalid phone number given". json_encode( ['number' => $data['to'], 'region'=> $data['region']]));
        }
        if (!$phoneUtil->isValidNumber($number)) {
            Log::error("Invalid phone number given", ['number' => $number]);

            return false;
        }
        Log::debug("Sending SMS", ['text' => $data['text']]);

        $apiInstance = new TransactionalSMSApi(
            new Client(),
            $this->config
        );
        $sendTransacSms = new SendTransacSms([
            'recipient' => str_replace(' ', '', $phoneUtil->format($number, PhoneNumberFormat::INTERNATIONAL)),
            'content'   => $data['text'],
            'sender'    => $data['from'],
            'tag'       => $data['tag'],
            'type'      => 'transactional'
        ]);

        try {
            $result = $apiInstance->sendTransacSms($sendTransacSms);
            if (!$result->valid()) {
                Log::error('Retour de Sms non valide');
                throw new BrevoException('Retour de Sms non valide');
            }
        } catch (Exception $e) {
            Log::debug("Exception sur l'envoi de SMS", [$e->getMessage(),$e]);
            throw new BrevoException($e->getMessage(), $e->getCode(), $e);
        }

        return true;
    }
}
