<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 16/03/2017
 * Time: 14:16
 */
namespace Bloom\LaravelBrevo;

use Bloom\LaravelBrevo\Facades\BrevoMailTransport;
use Illuminate\Support\ServiceProvider;
use Brevo\Client\Configuration;


class BrevoServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../config/brevo.php' => config_path('brevo.php'),
        ], 'brevo-config');
    }
    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(BrevoSmsTransport::class,
        $this->app->singleton(BrevoSmsTransport::class, function($app) {
            return new BrevoSmsTransport();
        }));
    }
}
