
## About laravel-brevo

Brevo est a nouvelle version de sendinblue : https://developers.brevo.com/

Il permet d'envoyer des mails et SMS via Brevo

## Package laravel-brevo

Ce package contient le package getbrevo/brevo-php https://packagist.org/packages/getbrevo/brevo-php

Ce package est développé avec la version de php : php8.2
La branche release/php8.1 est pour la version php8.1

Pour l'envoi des mails, seul la configuration du .env est nécessaire (pas d'installation du package). La configuration est dans le .env.exemple.

Pour l'envoi des SMS : l'installation du package est nécessaire + une configuration du .env.

## Configuration mail
Ajouter dans le .env


```
MAIL_MAILER=smtp
MAIL_HOST=smtp-relay.brevo.com
MAIL_PORT=587
MAIL_USERNAME=support@bloom-multimedia.fr
MAIL_PASSWORD= #voir le compte BREVO du support
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="support@bloom-multimedia.fr"
MAIL_FROM_NAME="${APP_NAME}"

BREVO_KEY=  #voir le compte BREVO du support
MAIL_TO_ADDRESS=
```

## Configuration sms
Installer la package
Dans le composer.json
```
 "bloom/laravel-brevo" : "v5.8.1"
```
Ajouter dans le .env


```
BREVO_KEY=  #voir le compte BREVO du support
BREVO_TAG= #personnaliser le tag
```

Publier les configs
```
 php8.2 artisan vendor:publish 
```
Sélectionner le provider brevo

```
Which provider or tag's files would you like to publish?

Provider: Bloom\LaravelBrevo\BrevoServiceProvider 
```

Le fichier config/brevo.php est désormais dans les configs de votre projet.

## Envoi SMS exemple
via la facade SMS
````
//inclure la facade 
use Bloom\LaravelBrevo\Facades\Sms;

//preparer le sms

$data = ["to" => "0612131415",
"from" => "LeadsHonda",
"text" => "Bonjour, ceci est un test",
"tag" => "asltest",
"type" => "transactional"
];

//envoyer le sms via la facade sms
Sms::send($data);
````

via l'api
````
POST : /api/send-sms

$data = ["to" => "0612131415",
"from" => "LeadsHonda",
"text" => "Bonjour, ceci est un test",
"tag" => "asltest",
"type" => "transactional"
];
````
## Changer la région du numéro de téléphone
Par défaut la région est FR

Ajouter le paramètre ``région``  dans les données envoyées à la facade ou à l'api.

Tester le numéro de téléphone / region ici : https://libphonenumber.appspot.com/
## Liste des routes


POST : api/send-mail

POST : api/send-sms

## Tests unitaires

Ce package contient des tests unitaires :`php8.2 artisan test`

## Logs des SMS / mails envoyés
Dans brevo: (se connecter avec le compte google du support)

pour les SMS https://app-sms.brevo.com/log

pour les mail : https://app-smtp.brevo.com/log
