<?php

namespace Tests\Feature;
use Bloom\LaravelBrevo\Facades\Sms;
use Tests\TestCase;

class SMSTest extends TestCase
{
    public function test_api_send_sms_ok(): void
    {
        $response = $this->post('/api/send-sms',
            ["to" => "0612131415",
                "from" => "LeadsHonda",
                "text" => "Bonjour, ceci est un test",
                "tag" => "asltest",
                "type" => "transactional"
            ]);

        $response->assertStatus(200);
    }
    public function test_send_sms_ok(): void
    {
        $data = ["to" => "0612131415",
            "from" => "LeadsHonda",
            "text" => "Bonjour, ceci est un test",
            "tag" => "asltest",
            "type" => "transactional"
        ];
        Sms::send($data);

        $this->assertTrue(true);
    }
}
