<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 05/07/18
 * Time: 12:07
 */

namespace Bloom\LaravelBrevo\Facades;

use Bloom\LaravelBrevo\BrevoSmsTransport;
use Illuminate\Support\Facades\Facade;

/**
 * Class Sms
 * @package Bloom\LaravelBrevo\Facades
 * @see BrevoSmsTransport
 * @method static boolean send(array $data) : Send a SMS
 */
class Sms extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return app(BrevoSmsTransport::class);
    }

    public static function __callStatic($method, $arguments)
    {
        return (static::getFacadeAccessor())->$method(...$arguments);
    }
}
