<?php

namespace Bloom\LaravelBrevo\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;


class ApiController extends Controller
{
    public function __construct()
    {
        //
    }
    public function sendMails(Request $request){
        $data = $request->all();

        $recipients= $data['to'];
        $erreurs = [];

        if(!empty($data['to']) && !is_array($data['to'])){
            $recipients = [$data['to']];
        }
        foreach ($recipients as $recipient){
            try{

                if(empty($recipient['email'])){
                    throw new \Exception( 'Le format des destinataires n\'est pas correct. format attendu : [ "email"=>"support@bloom-multimedia.fr","name"=> "support"]. params : '.json_encode($recipient));
                }

                \Mail::send(new \Bloom\LaravelBrevo\NotificationMail($request->all(), $recipient));
                Log::info( 'Email sent to '.$recipient['email'].' at ' . now(). " : ".json_encode($request->all()));
            }
            catch(\Exception $e ){
                $erreurs[] = $e->getMessage();
                Log::error( 'Erreur : '. $e->getMessage() );
                continue;
            }
        }
        if(count($erreurs)>0){
            return response()->json(['message'=>'errors', 'status'=>500, 'errors'=> $erreurs]);
        }
        return response()->json(['message'=>'success', 'status'=>200]);
    }
}
