<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 05/07/18
 * Time: 12:09
 */

namespace Bloom\LaravelBrevo;


use Exception;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;
use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumberFormat;
use libphonenumber\PhoneNumberUtil;
use Brevo\Client\Api\TransactionalSMSApi;
use Brevo\Client\Configuration;
use Brevo\Client\Model\SendTransacSms;


class BrevoSmsTransport
{
    /**
     * @var Configuration
     */
    protected $config;
    /**
     * @var string
     */
    protected $tag;

    public function __construct(Configuration $config, string $tag)
    {
        $this->tag = $tag;
        $this->config = $config;
    }

    public function send(string $to, string $text, string $from, string $region): bool
    {
        $phoneUtil = PhoneNumberUtil::getInstance();
        try {
            $number = $phoneUtil->parse($to, $region);
        } catch (NumberParseException $e) {

            Log::debug("Invalid phone number given", ['number' => $to]);

            //throw new BrevoException("Le numero de telephone est inexistant");
            return false;

        }
        if (!$phoneUtil->isValidNumber($number)) {
            Log::debug("Invalid phone number given", ['number' => $number]);

            return false;
        }
        Log::debug("Sending SMS", ['text' => $text]);

        $apiInstance = new TransactionalSMSApi(
            new Client(),
            $this->config
        );
        $sendTransacSms = new SendTransacSms([
            'recipient' => str_replace(' ', '', $phoneUtil->format($number, PhoneNumberFormat::INTERNATIONAL)),
            'content'   => $text,
            'sender'    => $from,
            'tag'       => $this->tag,
            'type'      => 'transactional'
        ]);

        try {
            $result = $apiInstance->sendTransacSms($sendTransacSms);
            if ($result->valid() == false) {
                Log::error('Retour de Sms non valide');
                throw new BrevoException('Retour de Sms non valide');
            }
        } catch (Exception $e) {
            Log::debug("Exception sur l'envoi de SMS", [$e->getMessage(),$e]);
            throw new BrevoException($e->getMessage(), $e->getCode(), $e);
        }

        return true;
    }
}
